//---------------------------------------------------------------------------

#ifndef CommControl_FormH
#define CommControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

//#include "USBConnection.h"
//#include "USBComm.h"
#include "TcpComm.h"
#include "common.h"
#include "Environment.h" 
#include <ExtCtrls.hpp>
#include <iostream>
using namespace std;

#define COMM_HCB				  0
#define COMM_SPB				  1
#define COMM_SPB_1				1
#define COMM_SPB_2				2
#define COMM_SPB_3				3
#define COMM_SPB_4				4
#define COMM_SPB_5				5
#define COMM_SPB_6				6
#define COMM_SPB_7				7
#define COMM_SPB_8				8
#define COMM_TPB					9

#define MAX_COMM_COUNT 10
//---------------------------------------------------------------------------
class TCommControlForm : public TForm
{
__published:	// IDE-managed Components
	TGroupBox *GroupBox1;
	TLabel *Label1;
	TLabel *HCBConnectionLabel;
	TLabel *Label3;
	TLabel *SPBConnectionLabel1;
	TLabel *Label5;
	TLabel *SPBConnectionLabel2;
	TLabel *Label7;
	TLabel *SPBConnectionLabel3;
	TLabel *Label9;
	TLabel *SPBConnectionLabel4;
	TButton *ReconnectButton1;
	TButton *RecoverButton1;
	TButton *ReconnectButton2;
	TButton *RecoverButton2;
	TButton *ReconnectButton3;
	TButton *RecoverButton3;
	TButton *ReconnectButton4;
	TButton *RecoverButton4;
	TButton *ReconnectButton5;
	TButton *RecoverButton5;
	TTimer *StatusTimer;
	TButton *CloseButton;
	TPanel *Panel1;
	void __fastcall StatusTimerTimer(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall ReconnectButtonClick(TObject *Sender);
	void __fastcall RecoverButtonClick(TObject *Sender);
	void __fastcall Panel1DblClick(TObject *Sender);
	void __fastcall Label9DblClick(TObject *Sender);
private:	// User declarations
	//TUSBComm USBConnection[1 + SYSTEM_SPB_COUNT];
	//bool FBusy;
   unsigned char cBuf[20];
	bool FBusy[MAX_COMM_COUNT];
  void __fastcall GetDefaultString();
	void __fastcall CheckStatus(void);
public:		// User declarations
	__fastcall TCommControlForm(TComponent* Owner);
	void __fastcall Connect(int commIndex);
	void __fastcall Disconnect(int commIndex);
	bool __fastcall IsConnected(int commIndex);
	bool __fastcall Request(int commIndex, unsigned short command, void *data = NULL, unsigned int dataLength = 0,
		void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0);
	bool __fastcall RequestEx(int commIndex, unsigned short command, void *shortData, unsigned int shortDataLength,
		void *longData, unsigned int longDataLength, void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0,
		TUSBCompletionRoutine CompletionRoutine = NULL, TOverlapIOStr *OverlapIOStr = NULL);
	void __fastcall SetMaxWaitingTime(int commIndex, int waitingTime);
	void __fastcall SetDefaultMaxWaitingTime(int commIndex);
	bool __fastcall Recover(int commIndex);
    void __fastcall Reconnect(int commIndex);
	void __fastcall RequestStallTest(int commIndex, int testMode);
            void __fastcall TxDataToTcp(AnsiString str);   //sjm TCPIP
    //void __fastcall AlarmDataToTcp(int code,Byte acode);   //sjm TCPIP
    int  __fastcall TxDatalength(AnsiString str);	//sjm TCPIP
    void __fastcall TxAlarmDataToTcp(int code, AnsiString str);    //sjm TCPIP
    TList *SOCLST;  //sjm TCPIP
    AnsiString ProgramPath_Root ;
    AnsiString SystemInfor_FileName;

    TTcpComm TcpConnection[SYSTEM_HCB_COUNT + SYSTEM_SPB_COUNT + SYSTEM_TPB_COUNT];
    int	 activemode; // 1-usb all 2-hcb-usb/tcp-spb  3-tcp all
};
//---------------------------------------------------------------------------
extern PACKAGE TCommControlForm *CommControlForm;

extern bool CommSimulationMode;
extern bool TcpSndFlag; 		 //TCPIP

extern void __fastcall Comm_Connect(int commIndex);
extern void __fastcall Comm_Disconnect(int commIndex);
extern void __fastcall Comm_ConnectAll(void);
extern void __fastcall Comm_DisconnectAll(void);
extern bool __fastcall Comm_IsConnected(int commIndex);

extern bool __fastcall Comm_Request(int commIndex, unsigned short command, void *data = NULL, unsigned int dataLength = 0,
	void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0);
extern bool __fastcall Comm_RequestEx(int commIndex, unsigned short command, void *shortData, unsigned int shortDataLength,
	void *longData, unsigned int longDataLength, void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0,
	TUSBCompletionRoutine CompletionRoutine = NULL, TOverlapIOStr *OverlapIOStr = NULL);

extern void __fastcall Comm_SetMaxWaitingTime(int commIndex, int waitingTime);
extern void __fastcall Comm_SetDefaultMaxWaitingTime(int commIndex);

extern bool __fastcall Comm_Recover(int commIndex);
extern void __fastcall Comm_RequestStallTest(int commIndex, int testMode);
extern void __fastcall Comm_Reconnect(int commIndex);
//---------------------------------------------------------------------------
#endif
